/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspVioEtherConfig {
    private UnsignedInt8 mIsIEEE;
    private UnsignedInt8 mIsTrunk;
    private UnsignedInt8 mPriority;
    private String mMACAddress;
    private UnsignedInt16 mPortVid;
    private UnsignedInt16[] mAdditionalVids;
    private UnsignedInt32 mDRCIndex;
    private String mDRCName;
    private static final String GET_VIRTUAL_ETHERNET_SLOT_CONFIGURATION = "GET_VIRTUAL_ETHERNET_SLOT_CONFIGURATION";
    private static final String IS_IEEE = "IS_IEEE";
    private static final String IS_TRUNK = "IS_TRUNK";
    private static final String PRIORITY = "PRIORITY";
    private static final String MAC_ADDRESS = "MAC_ADDRESS";
    private static final String PVID = "PVID";
    private static final String VID_LIST = "VID_LIST";
    private static final String VID = "VID";
    private static final String DRC_INDEX = "DRC_INDEX";
    private static final String DRC_NAME = "DRC_NAME";
    private static final String SET_VIRTUAL_ETHERNET_SLOT_CONFIGURATION = "SET_VIRTUAL_ETHERNET_SLOT_CONFIGURATION";

    public FspVioEtherConfig() {
    }

    public FspVioEtherConfig(UnsignedInt8 unsignedInt8, UnsignedInt8 unsignedInt82, UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt83, String string, UnsignedInt16[] unsignedInt16Array) {
        this.mIsIEEE = unsignedInt8;
        this.mPriority = unsignedInt82;
        this.mPortVid = unsignedInt16;
        this.mIsTrunk = unsignedInt83;
        this.mMACAddress = string;
        this.mAdditionalVids = unsignedInt16Array;
    }

    FspVioEtherConfig getVirtualEthernetSlotConfigurationCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_VIRTUAL_ETHERNET_SLOT_CONFIGURATION, new String[]{unsignedInt16.toString(), unsignedInt162.toString()}, 0, null, null, null, null, unsignedInt162);
        this.mIsIEEE = (UnsignedInt8)hashtable.get(IS_IEEE);
        this.mPriority = (UnsignedInt8)hashtable.get(PRIORITY);
        this.mPortVid = (UnsignedInt16)hashtable.get(PVID);
        this.mIsTrunk = (UnsignedInt8)hashtable.get(IS_TRUNK);
        byte[] byArray = (byte[])hashtable.get(MAC_ADDRESS);
        this.mMACAddress = ByteUtilities.toHexString(byArray);
        Object[] objectArray = (Object[])hashtable.get(VID_LIST);
        this.mAdditionalVids = new UnsignedInt16[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Hashtable hashtable2 = (Hashtable)objectArray[i];
            this.mAdditionalVids[i] = (UnsignedInt16)hashtable2.get(VID);
        }
        this.mDRCIndex = (UnsignedInt32)hashtable.get(DRC_INDEX);
        byte[] byArray2 = (byte[])hashtable.get(DRC_NAME);
        this.mDRCName = new String(byArray2).trim();
        return this;
    }

    static void setVirtualEthernetSlotConfigurationCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, FspVioEtherConfig fspVioEtherConfig) throws PIHscServerException, PIHscCmdMgrException {
        String string = ByteUtilities.toHexString(fspVioEtherConfig.getAdditionalVids());
        fSPCmdMgr.doPhypCommand(SET_VIRTUAL_ETHERNET_SLOT_CONFIGURATION, new String[]{unsignedInt16.toString(), unsignedInt162.toString(), fspVioEtherConfig.getIsIEEE().toString(), fspVioEtherConfig.getPriority().toString(), fspVioEtherConfig.getPortVid().toString(), fspVioEtherConfig.getIsTrunk().toString(), fspVioEtherConfig.getMACAddress(), Integer.toString(fspVioEtherConfig.getAdditionalVids().length), string}, 0, null, null, null, null, unsignedInt162);
    }

    public UnsignedInt8 getIsIEEE() {
        return this.mIsIEEE;
    }

    public void setIsIEEE(UnsignedInt8 unsignedInt8) {
        this.mIsIEEE = unsignedInt8;
    }

    public UnsignedInt8 getPriority() {
        return this.mPriority;
    }

    public boolean isRequired() {
        return this.mPriority != null && this.mPriority.intValue() == 2;
    }

    public void setPriority(UnsignedInt8 unsignedInt8) {
        this.mPriority = unsignedInt8;
    }

    public UnsignedInt16 getPortVid() {
        return this.mPortVid;
    }

    public void setPortVid(UnsignedInt16 unsignedInt16) {
        this.mPortVid = unsignedInt16;
    }

    public UnsignedInt8 getIsTrunk() {
        return this.mIsTrunk;
    }

    public void setIsTrunk(UnsignedInt8 unsignedInt8) {
        this.mIsTrunk = unsignedInt8;
    }

    public String getMACAddress() {
        return this.mMACAddress;
    }

    public void setMACAddress(String string) {
        this.mMACAddress = string;
    }

    public UnsignedInt16[] getAdditionalVids() {
        return this.mAdditionalVids;
    }

    public void setAdditionalVids(UnsignedInt16[] unsignedInt16Array) {
        this.mAdditionalVids = unsignedInt16Array;
    }

    public UnsignedInt32 getDrcIndex() {
        return this.mDRCIndex;
    }

    public String getDrcName() {
        return this.mDRCName;
    }

    public String toString() {
        String string = "isIEEE=";
        String string2 = "priority=";
        String string3 = "portVid=";
        String string4 = "isTrunk=";
        String string5 = "MACAddress=";
        String string6 = "additionalVids=";
        if (this.mIsIEEE != null) {
            string = string + this.mIsIEEE.toString();
        }
        if (this.mPriority != null) {
            string2 = string2 + this.mPriority.toString();
        }
        if (this.mPortVid != null) {
            string3 = string3 + this.mPortVid.toString();
        }
        if (this.mIsTrunk != null) {
            string4 = string4 + this.mIsTrunk.toString();
        }
        if (this.mMACAddress != null) {
            string5 = string5 + this.mMACAddress;
        }
        if (this.mAdditionalVids != null) {
            for (int i = 0; i < this.mAdditionalVids.length; ++i) {
                string6 = string6 + this.mAdditionalVids[i].toString() + " ";
            }
        }
        return string + "; " + string2 + "; " + string3 + "; " + string4 + "; " + string5 + "; " + string6;
    }
}

